require( "scripts/style.lua" );

require( "scripts/basicSetting.lua");

guestCreationDelay = 30000;
guestCreationSpeedIncrease = 2400;
minGuestsToCreate = 2;
maxGuestsToCreate = 3;

useWineTable = 0;
numMoodBoosts =3;

--Arcade 1

levelSetting1 = 
{
	-- total of 100%
	guestListPercentage = 
	{
		female01Percent=15,
		female02Percent=0,
		female03Percent=15,
		female04Percent=10,
		male01Percent=10,
		male02Percent=15,
		male03Percent=0,
		male04Percent=10,
		unclePercent=15,
		auntPercent=10
	},
	
	guestAttributes = 
	{
	-- low to high range
	-- percentage from 0 to 100
		tolerance =		{70000, 80000},
		waitBeforeSit =		{1000, 1000},
		waitBeforeAppetizer =	{1000, 1000},
		waitBeforeDinner =	{8000, 8000},
		waitBeforeCake =	{12000, 12000},
		waitBeforeGift =	{1000, 1000},
		percentRequestDrink =	{0, 0},
		percentRequestMusic =	{0, 0},
		percentRequestResit =	{0, 0},
		percentRequestCoffee =	{10, 50},
		percentRequestTissue =	{10, 50}
	}
}




dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();
LManager:SetLevelNumber(2,1);
LManager:AddNewTable( 1, 4, 270, 230, "assets/images/table/bluetable", "assets/images/food/item_mark3", "B" );
LManager:AddNewTable( 2, 3, 220, 360, "assets/images/table/redtable", "assets/images/food/item_mark1", "R" );
LManager:AddNewTable( 3, 3, 300, 485, "assets/images/table/redtable", "assets/images/food/item_mark2", "R" );


LManager:SetLevelSetting ("speakerDelay", 300000);
LManager:SetLevelSetting ("speakerChance", 20);
LManager:SetLevelSetting ("blaster", 1);

LManager:SetLevelSetting ("bridesmaidsDelay", 400000);
LManager:SetLevelSetting ("bridesmaidsChance", 100);

-- Testing...
LManager:SetLevelSetting( "guestLeaveAllow", 5 );

gameObject = LManager:GenerateGameObject();

levelSetting = LManager:GenerateLevelSettings();
levelSetting.mode = "endless";
levelSetting.passScore = 
	{
	    500 -- the base score. for each level the passScore is baseScore + baseScore*level*level
	};
	
--dofile( "scripts/LevelDialogGenerator.lua" );

LManager:SetChairImage("assets/images/table/chair02");

MakeDialog
{

	Bitmap
	{
		name="backgroundimage",
		image="images/bg_ballroom",
				
		GameWindow
		{ 	
			x = 0, y = 0, w = kMax, h = kMax,
			Button{
			x=800, y=600, --set offscreen
			--x=140,
			--y=550,
			font = StandardButtonFont,
			graphics = StandardButtonGraphics,
			name="upgrade",
			label="upgradetitle",
			type = kPush,
			command = 
				function()
				    OpenArcadeUpgrade();
				end
				
			};			
		},
		-- the pause button
		Button{
			x=10,
			y=550,
			font = StandardButtonFont,
			graphics = StandardButtonGraphics,
			name="pause",
			label="ui.dialog.pause.title",
			type = kPush,
			command = 
				function()
				    DoPause();
				end
				
		};
	},
	
}
